#!/usr/bin/perl
#
$Version = 0.01;
@ARGV = (	"../phrases/phrases_en.xml",
			"../../release/forums/local_links.php",
			"../../release/forums/local_links_actions.php",
			"../../release/forums/local_links_admin.php",
			"../../release/forums/local_links_search.php",
			"../../release/forums/includes/local_links_include.php",
			"../../release/forums/includes/local_links_misc.php",
			"../../release/forums/includes/local_links_resize.php",
			"../templates/templates.xml");

#
# Extracts the phrases from $argv[0] and cross-references against phrases in all other arguments
#
# Usage : phraseval.pl
#

use strict;

my $XML;
my $FILE;
my $phraselist = "";

my $xml = shift @ARGV;
open $XML , "<", $xml or die "Unable to open $xml";
while (<$XML>) { $phraselist .= $_; }
close $XML;

my %set_phrases = ();
while ($phraselist =~ m/<phrase name="(.*?)"/gs) {
    $set_phrases{$1} = 0;
}

while (my $file = shift @ARGV) {
    print $file."\n";
    open $FILE , "<", $file or die "Unable to open $file";
    $phraselist = "";
    while (<$FILE>) { $phraselist .= $_; }
    close $FILE;
    $phraselist =~ s/\$vbphrase\['[^']*'[\w\.]+\$[^\[]*\[[^\]]*\]\]//gs; # eliminate concatenations
    while ($phraselist =~ m/(\$vbphrase\[['"]*(.*?)['"]*\])/gs) {
        if (exists $set_phrases{$2}) {
            $set_phrases{$2}++;
        }
        else {
            print "Unrecognised: ".$2."\n";
        }
    }
}

print "\n\n";
foreach my $k (sort keys %set_phrases) {
    printf "%3d %s\n" , $set_phrases{$k}, $k;
}

